<?php
session_start();
include 'conf.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<title>#KIS21 - El mayor evento de innovación en el área de Salud de América Latina</title>
		<meta property="og:title" content="#KIS21" />
		<meta property="og:description" content="KIS21 - El mayor evento de innovación en el área de Salud de América Latina" />
        <meta property="og:url" content="https://fis.org.br/kis21/es" />
		<meta property="og:image" content="https://fis.org.br/kis21/images/kis21-tb.jpg" />



		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=UA-163827397-1"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());

          gtag('config', 'UA-163827397-1');
        </script>


		<!-- Global site tag (gtag.js) - Google Ads: 585226698 -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=AW-585226698"></script>
		<script>
			window.dataLayer = window.dataLayer || [];
			function gtag(){dataLayer.push(arguments);}
			gtag('js', new Date());

			gtag('config', 'AW-585226698');
		</script>


		<!-- Global site tag (gtag.js) - Google Ads: 631769898 -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=AW-631769898"></script>
		<script>
			window.dataLayer = window.dataLayer || [];
			function gtag(){dataLayer.push(arguments);}
			gtag('js', new Date());

			gtag('config', 'AW-631769898');
		</script>


		<!-- Facebook Pixel Code -->
			<script>
			!function(f,b,e,v,n,t,s)
			{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
			n.callMethod.apply(n,arguments):n.queue.push(arguments)};
			if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
			n.queue=[];t=b.createElement(e);t.async=!0;
			t.src=v;s=b.getElementsByTagName(e)[0];
			s.parentNode.insertBefore(t,s)}(window, document,'script',
			'https://connect.facebook.net/en_US/fbevents.js');
			fbq('init', '3330751026961828');
			fbq('track', 'PageView');
		</script>




		<link rel="preconnect" href="https://fonts.gstatic.com">
		<link href="https://fonts.googleapis.com/css2?family=Bai+Jamjuree:wght@400;500;600;700&display=swap" rel="stylesheet">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.css">

		<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
		<script src="<?php echo INCLUDE_PATH; ?>js/jquery.downCount-es.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.6.0/slick.js"></script>



		<link href="<?php echo INCLUDE_PATH; ?>estilo/all.css" rel="stylesheet"> <!--load all styles -->
		<link href="<?php echo INCLUDE_PATH; ?>estilo/style.css" rel="stylesheet" />
		<link href="<?php echo INCLUDE_PATH; ?>estilo/carousel.css" rel="stylesheet" />
		<link href="<?php echo INCLUDE_PATH; ?>estilo/clock.css" rel="stylesheet" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="keywords" content="kis21,Salud,innovación,evento,lideranças,tecnologia">
		<meta name="description" content="KIS21 - El mayor evento de innovación en el área de Salud de América Latina">
		<link rel="icon" href="<?php echo INCLUDE_PATH; ?>favicon.ico" type="image/x-icon" />
		<meta charset="utf-8" />


	</head>

	<body>
		<div id="inicio-page"></div>
		<!--HEADER-->
		<div class="idiomas">
			<div><a href="<?php echo INCLUDE_PATH; ?>"><img src="<?php echo INCLUDE_PATH; ?>images/ico_bra.png" /></a></div>
			<div><a href="<?php echo INCLUDE_PATH; ?>en"><img src="<?php echo INCLUDE_PATH; ?>images/ico_usa.png" /></a></div>
			<div><a href="<?php echo INCLUDE_PATH; ?>es"><img src="<?php echo INCLUDE_PATH; ?>images/ico_esp.png" /></a></div>
		</div>

		<!-- HEADER REQUIRE -->
		<?php require_once "./components/header/header-es.html"?>

		<!-- BANNER PRINCIPAL -->

		<section class="banner-principal">
			<div class="center">
				<div class="logobanner">
					<img src="<?php echo INCLUDE_PATH; ?>images/logo_b.png" />
				</div>
				<div class="titulobanner">
					<p>El mayor evento de innovación en el área de Salud de América Latina</p>
				</div>
				<div class="databanner">
					<p>03, 04, 05 y 06 de Mayo</p>
				</div>
				<div class="btnbanner">
					<a href="https://trst.com.br/signin"><button type="button">Acceso #KIS21</button></a>
				</div>
			</div>
		</section>


		<!-- SOBRE O KIS -->

		<section class="sobre-kis">
			<div class="center">
				<div class="titulodiv">
					<h2 class="title">SOBRE EL #KIS21</h2>
					<p class="subtitle">
						Nuestra gran contribución para la innovación en la Salud. Un evento para destacarse en el sector, con grandes líderes, intercambio de experiencias y mucho contenido e interacción.
					</p>
					<br>
					<p class="subtitle">100% digital y 100% gratuito y con la cara de la #INICIATIVAFIS.</p>
					<br>
					<p class="subtitle">Transmisión en vivo en Español, Portugués y Inglés.</p>
				</div>
			</div>
		</section>


		<!-- LIDERES CONFIRMADOS -->

		<section class="lideres-confirmados">
			<p class="titlelider">LÍDERES CONFIRMADOS HASTA EL MOMENTO</p>
			<div class="center">
				<div class="flex-lider">
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/alejandro-moran.png">
						<p class="nomelider">Alejandro Morán</p>
						<p class="cargolider">Socio y Jefe de Salud y Seguros de las Américas</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/grahame-grieve.png">
						<p class="nomelider">Grahame Grieve</p>
						<p class="cargolider">HL7 FHIR Product Director and Principal at Health Intersections Pty Ltd</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/harry-loboa.png">
						<p class="nomelider"> Harry Loboa</p>
						<p class="cargolider">Head of Healthcare LATAM en AWS</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/josier-vilar.png">
						<p class="nomelider">Josier Vilar</p>
						<p class="cargolider">Presidente de la Iniciativa FIS</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/lena-rogovin.png">
						<p class="nomelider">Lena Rogovin</p>
						<p class="cargolider">Senior Digital Health & Life Sciences Analyst na Start-Up Nation Central </p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/rogerio-boros.png">
						<p class="nomelider">Rogerio Boros</p>
						<p class="cargolider">Director de Salud y Gobierno Federal de Microsoft Brasil</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/sarosh-mistry.png">
						<p class="nomelider">Sarosh Mistry</p>
						<p class="cargolider">President of Sodexo North America and CEO Homecare Worldwide</p>
					</div>
					<div>
						<img class="fotolider" src="<?php echo INCLUDE_PATH; ?>images/lideres/todos/sharon-chan.png">
						<p class="nomelider">Sharon Chan</p>
						<p class="cargolider">Head, Johnson & Johnson Innovation-JLABS, Asia Pacific</p>
					</div>
				</div>
			</div>

			<div class="embreve-parti">
				<a href="<?php echo INCLUDE_PATH; ?>palestrantes-es"><p>Todos los participantes</p></a>
			</div>
		</section>






		<!-- NUMEROS EVENTO -->
		<section class="numeros-conteiner">
			<div class="center">
				<div class="flex2">
					<div>
						<p class="numeros">4</p>
						<p class="numerostxt">Días de Evento   </p>
						<p class="numerostxt"><br /></p>
					</div>
					<div>
						<p class="numeros">+36</p>
						<p class="numerostxt">Horas de </p>
						<p class="numerostxt">Transmisión</p>
					</div>
					<div>
						<p class="numeros">+100</p>
						<p class="numerostxt">Líderes</p>
						<p class="numerostxt">Confirmados</p>
					</div>
					<div>
						<p class="numeros">+120</p>
						<p class="numerostxt">Empresas</p>
						<p class="numerostxt">involucradas</p>
					</div>
					<div>
						<p class="numeros">+15</p>
						<p class="numerostxt">Startups</p>
						<p class="numerostxt"><br /></p>
					</div>
					<div>
						<p class="numeros">8</p>
						<div id="inscricao-agora"></div>
						<p class="numerostxt">Países</p>
						<p class="numerostxt"><br /></p>

					</div>

				</div>
			</div>
		</section>

		<!-- FORMULARIO DE INSCRIÇÃO -->
		<!-- <?php require_once "./components/inscricao/inscricao-es.html"?> -->


		<!-- NEWSLETTER -->
		<!--
		<section class="newsletter">
				<div class="center">
					<p class="newstitulo">Inscreva-se em nossa newsletter e saiba das últimas novidades do #KIS21</p>
					<form class="formnews">
						<span><input type="text" placeholder="Nome" /></span>
						<span><input type="email" placeholder="E-mail"/></span>
						<span><input type="submit" value="Cadastrar"></span>
						<br />
						<p class="checknews"><input type="checkbox" /><span class="termonews">Eu li e concordo com os termos de uso.</span></p><br />
						<p class="confirma">Ao continuar você poderá receber conteúdo de divulgação dos eventos da Iniciativa FIS. Você pode alterar suas permissões a qualquer momento.</p>
					</form>

				</div>
		</section>
		-->



		<!-- PROGRAMAÇÃO PRELIMINAR -->
		<section class="programacao-preliminar">
			<div>
				<p class="titleprogramacao">PROGRAMACIÓN (GMT-3)</p>
			</div>
			<div class="center">
				<div class="box-programacao">
					<div class="diaproga diacolor3">DIA 03 </div>
					<div class="horarioproga">12h40 às 13h45 | </div>
					<div class="descricaoproga">Por dentro de HealthTechs de Éxito</div>
				</div>
				<div class="box-programacao">
					<div class="diaproga diacolor4">DIA 04</div>
					<div class="horarioproga">16h45 às 17h15 | </div>
					<div class="descricaoproga">Conozca la Estrategia Integrando Datos de los Pacientes</div>
				</div>
				<div class="box-programacao">
					<div class="diaproga diacolor5">DIA 05</div>
					<div class="horarioproga">16h05 às 17h15 | </div>
					<div class="descricaoproga">Mujeres, Tecnología y la Salud</div>
				</div>
				<div class="box-programacao">
					<div class="diaproga diacolor6">DIA 06</div>
					<div class="horarioproga">12h50 às 13h55 | </div>
					<div class="descricaoproga">El futuro de la Educación en la Salud</div>
				</div>
				<div class="embreve-prog">
				<a href="<?php echo INCLUDE_PATH; ?>programacao-es"><p>Toda la Programación</p></a>
				</div>
			</div>
		</section>



		<!-- DIVISÃO -->
		<section class="divisao">
			<div></div>
		</section>



		<!-- QUEM SOMOS -->
		<section class="quemsomos">
			<div class="center">
				<h2>QUIENES SOMOS</h2>
				<p>Creada para conectar y unir a los mayores líderes, empresas y asociaciones de la cadena de la Salud,
					tanto del sector público, del privado y del académico, generando discusiones sobre los principales pilares del sector.
				</p>

				<div class="box-quemsomos">

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/01.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/02.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/03.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/04.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/05.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/06.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/07.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/08.png">
					</div><!--box-pilares-->

					<div class="box-pilares pilanulo">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/09.png">
					</div><!--box-pilares-->

					<div class="box-pilares">
						<img class="fotopilares" src="<?php echo INCLUDE_PATH; ?>images/pilares/es/10.png">
					</div><!--box-pilares-->

					<div class="box-pilares pilanulo">
					</div><!--box-pilares-->
				</div>
			</div>
		</section>


		<!-- TRST INÍCIO-->
		<section class="trst">
			<div class="center">
				<div class="trst-box">
					<h2 class="trst-title">CONOZCA LA #TRST</h2>
					<img src="<?php echo INCLUDE_PATH; ?>images/logo_trst.png" />
					<p class="trst-subtitle">( <i class="fas fa-smile"></i> Se pronuncia TRUST <i class="fas fa-grin-wink"></i> )</p>
					<p class="trst-subtitle">
						#TRST ( <i class="fas fa-laugh-squint"></i> la "U" es invisible!!! <i class="fas fa-grin-tongue-wink"></i> ) es la plataforma de conexión de la Iniciativa FIS y será la casa del #KIS21 en su lanzamiento!
					<br /><br />Aguarde!
					</p>
				</div>
			</div>
		</section>
		<!-- TRST  FINAL-->





		<!-- PARCEIROS -->
		<?php include 'footer-es.php';?>




		<!-- BOTAO HOME -->
		<a href="#inicio-page" class="botao-home">
			<i class="fas fa-home"></i>
		</a>




		<script>
			function flipTo(digit, n) {
			var current = digit.attr('data-num');
			digit.attr('data-num', n);
			digit.find('.front').attr('data-content', current);
			digit.find('.back, .under').attr('data-content', n);
			digit.find('.flap').css('display', 'block');
			setTimeout(function() {
				digit.find('.base').text(n);
				digit.find('.flap').css('display', 'none');
			}, 350);
		}

		function jumpTo(digit, n) {
			digit.attr('data-num', n);
			digit.find('.base').text(n);
		}

		function updateGroup(group, n, flip) {
			var digit1 = $('.ten' + group);
			var digit2 = $('.' + group);
			n = String(n);
			if (n.length == 1) n = '0' + n;
			var num1 = n.substr(0, 1);
			var num2 = n.substr(1, 1);
			if (digit1.attr('data-num') != num1) {
				if (flip) flipTo(digit1, num1);
				else jumpTo(digit1, num1);
			}
			if (digit2.attr('data-num') != num2) {
				if (flip) flipTo(digit2, num2);
				else jumpTo(digit2, num2);
			}
		}

		function setTime(time, flip) {

			let tSplit = [...time + ''].map(n => +n) //[1, 2, 3, 4, 5]
			updateGroup('cen', tSplit[0].toString() + tSplit[1].toString(), flip);
			updateGroup('dez', tSplit[2].toString() + tSplit[3].toString(), flip);
		}

		async function getSubsFromDB() {
			return await fetch("<?php echo INCLUDE_PATH; ?>functions/get-subs.php")
				.then((response) => response.json())
				.then((result) => {
						return (parseInt(result) + 0)
				});
		}

		$(document).ready(function() {
			getSubsFromDB().then((subs) => setTime(subs, false));
			setInterval(function() {
				getSubsFromDB().then((subs) => setTime(subs, true));
			}, 2000);
		});
		</script>

		<!-- SCRIPT CAROUSEL LOGOS -->
		<script class="source" type="text/javascript">
			$(document).ready(function(){
				$('.customer-logos').slick({
					slidesToShow: 3,
					slidesToScroll: 3,
					autoplay: true,
					autoplaySpeed: 6000,
					arrows: false,
					dots: false,
					pauseOnHover: false,
					responsive: [{
						breakpoint: 768,
						settings: {
							slidesToShow: 3,
							slidesToScroll: 3
						}
					}, {
						breakpoint: 520,
						settings: {
							slidesToShow: 3,
							slidesToScroll: 3
						}
					}]
				});
			});
		</script>

		<script class="source" type="text/javascript">
			$(document).ready(function(){
				$('.customer-logos2').slick({
					slidesToShow: 4,
					slidesToScroll: 4,
					autoplay: true,
					autoplaySpeed: 5000,
					arrows: false,
					dots: false,
					pauseOnHover: false,
					responsive: [{
						breakpoint: 768,
						settings: {
							slidesToShow: 4,
							slidesToScroll: 4
						}
					}, {
						breakpoint: 520,
						settings: {
							slidesToShow: 4,
							slidesToScroll: 4
						}
					}]
				});
			});
		</script>

		<script class="source" type="text/javascript">
			$(document).ready(function(){
				$('.customer-logos3').slick({
					slidesToShow: 8,
					slidesToScroll: 8,
					autoplay: true,
					autoplaySpeed: 3000,
					arrows: false,
					dots: false,
					pauseOnHover: false,
					responsive: [{
						breakpoint: 768,
						settings: {
							slidesToShow: 6,
							slidesToScroll: 6
						}
					}, {
						breakpoint: 520,
						settings: {
							slidesToShow: 5,
							slidesToScroll: 5
						}
					}]
				});
			});
		</script>


		<!-- SCRIPT CONTADOR REGRESSIVO -->
		<script class="source" type="text/javascript">
			$('.countdown').downCount({
				date: '05/03/2021 10:00:00',
				offset: -3
			}, function () {
				alert('CHEGOU O DIA!');
			});
		</script>







	</body>
</html>